% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx.R
\name{dfmx}
\alias{dfmx}
\alias{pfmx}
\alias{qfmx}
\alias{rfmx}
\title{Density, Distribution and Quantile of Finite Mixture Distribution}
\usage{
dfmx(
  x,
  dist,
  distname = dist@distname,
  K = dim(pars)[1L],
  pars = dist@pars,
  w = dist@w,
  ...,
  log = FALSE
)

pfmx(
  q,
  dist,
  distname = dist@distname,
  K = dim(pars)[1L],
  pars = dist@pars,
  w = dist@w,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qfmx(
  p,
  dist,
  distname = dist@distname,
  K = dim(pars)[1L],
  pars = dist@pars,
  w = dist@w,
  interval = qfmx_interval(dist = dist),
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

rfmx(
  n,
  dist,
  distname = dist@distname,
  K = dim(pars)[1L],
  pars = dist@pars,
  w = dist@w
)
}
\arguments{
\item{x, q}{\link[base]{numeric} \link[base]{vector}, quantiles, \code{NA_real_} value(s) allowed.}

\item{dist}{\linkS4class{fmx} object, a finite mixture distribution}

\item{distname, K, pars, w}{auxiliary parameters, whose default values are determined by argument \code{dist}.
The user-specified \link[base]{vector} of \code{w} does not need to sum up to 1; \code{w/sum(w)} will be used internally.}

\item{...}{additional parameters}

\item{log, log.p}{\link[base]{logical} scalar.
If \code{TRUE}, probabilities are given as \eqn{\log(p)}.}

\item{lower.tail}{\link[base]{logical} scalar.
If \code{TRUE} (default), probabilities are \eqn{Pr(X\le x)}, otherwise, \eqn{Pr(X>x)}.}

\item{p}{\link[base]{numeric} \link[base]{vector}, probabilities.}

\item{interval}{length two \link[base]{numeric} \link[base]{vector}, interval for root finding, see \link[rstpm2]{vuniroot}}

\item{n}{\link[base]{integer} scalar, number of observations.}
}
\value{
Function \code{\link[=dfmx]{dfmx()}} returns a \link[base]{numeric} \link[base]{vector} of probability density values of an \linkS4class{fmx} object at specified quantiles \code{x}.

Function \code{\link[=pfmx]{pfmx()}} returns a \link[base]{numeric} \link[base]{vector} of cumulative probability values of an \linkS4class{fmx} object at specified quantiles \code{q}.

Function \code{\link[=qfmx]{qfmx()}} returns an unnamed \link[base]{numeric} \link[base]{vector} of quantiles of an \linkS4class{fmx} object, based on specified cumulative probabilities \code{p}.
Note that \link[stats]{qnorm} returns an unnamed \link[base]{vector} of quantiles,
although \link[stats]{quantile} returns a named \link[base]{vector} of quantiles.

Function \code{\link[=rfmx]{rfmx()}} generates random deviates of an \linkS4class{fmx} object.
}
\description{
Density function, distribution function, quantile function and random generation for a finite mixture distribution
with normal or Tukey's \eqn{g}-&-\eqn{h} components.
}
\details{
A computational challenge in function \code{\link[=dfmx]{dfmx()}} is when mixture density is very close to 0,
which happens when the per-component log densities are negative with big absolute values.
In such case, we cannot compute the log mixture densities (i.e., \code{-Inf}),
for the log-likelihood using function \code{\link[=logLik.fmx]{logLik.fmx()}}.
Our solution is to replace these \code{-Inf} log mixture densities by
the weighted average (using the mixing proportions of \code{dist})
of the per-component log densities.

Function \code{\link[=qfmx]{qfmx()}} gives the quantile function, by numerically solving \link{pfmx}.
One major challenge when dealing with the finite mixture of Tukey's \eqn{g}-&-\eqn{h} family distribution
is that Brent–Dekker's method needs to be performed in both \link{pGH} and \link{qfmx} functions,
i.e. \emph{two layers} of root-finding algorithm.
}
\examples{

x = (-3):7

(e1 = fmx('norm', mean = c(0,3), sd = c(1,1.3), w = c(1, 1)))
isS4(e1) # TRUE
slotNames(e1)
autoplot(e1)
hist(rfmx(n = 1e3L, dist = e1), main = '1000 obs from e1')
# generate a sample of size 1e3L from mixture distribution `e1`
round(dfmx(x, dist = e1), digits = 3L)
round(p1 <- pfmx(x, dist = e1), digits = 3L)
stopifnot(all.equal.numeric(qfmx(p1, dist = e1), x, tol = 1e-4))

(e2 = fmx('GH', A = c(0,3), g = c(.2, .3), h = c(.2, .1), w = c(2, 3)))
hist(rfmx(n = 1e3L, dist = e2), main = '1000 obs from e2') 
round(dfmx(x, dist = e2), digits = 3L)
round(p2 <- pfmx(x, dist = e2), digits = 3L)
stopifnot(all.equal.numeric(qfmx(p2, dist = e2), x, tol = 1e-4))

(e3 = fmx('GH', A = 0, g = .2, h = .2)) # one-component Tukey
hist(rfmx(1e3L, dist = e3))
hist(rGH(n = 1e3L, A = 0, g = .2, h = .2))
# identical (up to random seed); but ?rfmx has much cleaner code
round(dfmx(x, dist = e3), digits = 3L)
round(p3 <- pfmx(x, dist = e3), digits = 3L)
stopifnot(all.equal.numeric(qfmx(p3, dist = e3), x, tol = 1e-4))

if (FALSE) {
  # log-mixture-density smoothing, for developers
  (e4 = fmx('norm', mean = c(0,3), w = c(2, 3)))
  curve(dfmx(x, dist = e4, log = TRUE), xlim = c(-50, 50))
}

}
