% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_geom_function_args_vanilla.R
\name{geom_function_args}
\alias{geom_function_args}
\title{\link[ggplot2]{geom_function} with Multiple Sets of Arguments}
\usage{
geom_function_args(args, ...)
}
\arguments{
\item{args}{\emph{named} \link[base]{list} of arguments}

\item{...}{parameters of \link[ggplot2]{geom_function},
most importantly the parameter \code{fun}}
}
\value{
Function \code{\link[=geom_function_args]{geom_function_args()}} returns a \link[base]{list} of \link[ggplot2]{ggplot} \link[ggplot2]{layer}s.
}
\description{
..
}
\details{
Function \code{\link[=geom_function_args]{geom_function_args()}} plots \emph{one} function using a \emph{list of} arguments,
by calling \link[ggplot2]{geom_function} repetitively.
The colour labels are the names of argument list \code{args}.
}
\note{
Parameter \code{args} of \link[ggplot2]{geom_function} is \emph{not} vectorized.

See \link[ggplot2]{geom_function}, for the difference from \link[ggplot2]{stat_function}.
}
\examples{
ggplot() + 
 geom_function_args(
   args = c('$\\\\alpha$' = 1, '$\\\\beta$' = 2), 
   fun = function(x, a) a*x^2, 
   xlim = c(-3, 3)) + 
 labs(colour = 'Args')

}
