% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kolmogorov_dist_vanilla.R
\name{Kolmogorov_dist}
\alias{Kolmogorov_dist}
\title{One-Sample Kolmogorov Distance}
\usage{
Kolmogorov_dist(
  obs,
  null,
  alternative = c("two.sided", "less", "greater"),
  ...
)
}
\arguments{
\item{obs}{\link[base]{numeric} or \link[base]{integer} \link[base]{vector}, observations}

\item{null}{cumulative distribution \link[base]{function}}

\item{alternative}{\link[base]{character} scalar,
alternative hypothesis, either \code{'two.sided'} (default), \code{'less'}, or \code{'greater'}}

\item{...}{additional arguments of \code{null}}
}
\value{
\link{Kolmogorov_dist} returns a \link[base]{numeric} scalar.
}
\description{
To calculate the one-sample Kolmogorov distance between observations and
a distribution.
}
\details{
\link{Kolmogorov_dist} is different from \link[stats]{ks.test} in the
following aspects
\itemize{
\item {Ties in observations are supported.
The step function of empirical distribution is inspired by \link[stats]{ecdf}.
This is superior than \code{(0:(n - 1))/n} of \code{stats:::ks.test.default}.}
\item {Discrete distribution (with discrete observation) is supported.}
\item {Discrete distribution (with continuous observation) is not supported yet.
This will be an easy modification in future.}
\item {Only the one-sample Kolmogorov distance, not the one-sample Kolmogorov test, is returned,
to speed up the calculation.}
}
}
\examples{
# from ?stats::ks.test
x1 <- rnorm(50)
ks.test(x1+2, y = pgamma, shape = 3, rate = 2)
Kolmogorov_dist(x1+2, null = pgamma, shape = 3, rate = 2) # exactly the same

# discrete distribution
x2 <- rnbinom(n = 1e2L, size = 500, prob = .4)
suppressWarnings(ks.test(x2, y = pnbinom, size = 500, prob = .4)) # warning on ties
Kolmogorov_dist(x2, null = pnbinom, size = 500, prob = .4) # wont be the same

}
\seealso{
\link[stats]{ks.test}
}
