% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.test.R
\name{summary,pk.test-method}
\alias{summary,pk.test-method}
\title{Summarizing kernel-based quadratic distance results}
\usage{
\S4method{summary}{pk.test}(object)
}
\arguments{
\item{object}{Object of class \code{pk.test}}
}
\value{
List with the following components:
\itemize{
\item \code{summary_tables} Table of computed descriptive statistics per
variable.
\item \code{test_results} Data frame with the results of the performed
Poisson kernel-based test.
\item \code{qqplots} Figure with qq-plots for each variable against the
uniform distribution.
}
}
\description{
\code{summary} method for the class \code{pk.test}
}
\examples{
# create a pk.test object
x_sp <- sample_hypersphere(3, n_points=100)
unif_test <- pk.test(x_sp,rho=0.8)
summary(unif_test)

}
