% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{pkbc}
\alias{pkbc}
\alias{pkbc,ANY-method}
\alias{show,pkbc-method}
\title{Poisson kernel-based clustering on the sphere}
\usage{
pkbc(
  dat,
  nClust = NULL,
  maxIter = 300,
  stoppingRule = "loglik",
  initMethod = "sampleData",
  numInit = 10
)

\S4method{pkbc}{ANY}(
  dat,
  nClust = NULL,
  maxIter = 300,
  stoppingRule = "loglik",
  initMethod = "sampleData",
  numInit = 10
)

\S4method{show}{pkbc}(object)
}
\arguments{
\item{dat}{Data matrix or data.frame of data points on the sphere to be
clustered. The observations in dat are normalized to ensure that
they lie on the d-simensional sphere. Note that d > 1.}

\item{nClust}{Number of clusters. It can be a single value or a numeric
vector.}

\item{maxIter}{The maximum number of iterations before a run is terminated.}

\item{stoppingRule}{String describing the stopping rule to be used within
each run. Currently must be either:
\code{'max'} (until the change in the log-likelihood is less
than a given threshold (1e-7)),
\code{'membership'} (until the membership is unchanged), or
\code{'loglik'} (based on a maximum number of iterations).}

\item{initMethod}{String describing the initialization method to be used.
Currently must be \code{'sampleData'}.}

\item{numInit}{Number of initializations.}

\item{object}{Object of class \code{pkbc}}
}
\value{
An S4 object of class \code{pkbc} containing the results of the
clustering procedure based on Poisson kernel-based distributions. The object
contains the following slots:

\code{res_k}: List of results of the Poisson kernel-based clustering
algorithm for each value of number of clusters specified in \code{nClust}.
Each object in the list contains:
\itemize{
\item \code{postProbs} Posterior probabilities of each observation for
the indicated clusters.
\item \code{LogLik} Maximum value of log-likelihood function
\item \code{wcss} Values of within-cluster sum of squares computed with
Euclidean distance and cosine similarity, respectively.
\item \code{params} List of estimated parameters of the mixture model
\itemize{
\item \code{mu} estimated centroids
\item \code{rho} estimated concentration parameters rho
\item \code{alpha} estimated mixing proportions
}
\item \code{finalMemb} Vector of final memberships
\item \code{runInfo} List of information of the EM algorithm iterations
\itemize{
\item \code{lokLikVec} vector of log-likelihood values
\item \code{numIterPerRun} number of E-M iterations per run
}
}
\code{input}: List of input information.
}
\description{
The function \code{pkbc} performs the Poisson kernel-based clustering
algorithm on the sphere based on the Poisson kernel-based densities.
}
\details{
The function estimates the parameter of a mixture of Poisson
kernel-based densities. The obtained estimates are used for assigning final
memberships, identifying the \code{nClust} clusters.
}
\examples{
#We generate three samples of 100 observations from 3-dimensional
#Poisson kernel-based densities with rho=0.8 and different mean directions
size<-100
groups<-c(rep(1, size), rep(2, size),rep(3,size))
rho<-0.8
set.seed(081423)
data1<-rpkb(size, c(1,0,0),rho,method="rejvmf")
data2<-rpkb(size, c(0,1,0),rho,method="rejvmf")
data3<-rpkb(size, c(0,0,1),rho,method="rejvmf")
dat<-rbind(data1$x,data2$x, data3$x)

#The following code can be used for plotting
\donttest{
library("rgl")
plot3d(dat,col = groups, size=4,xlab = "", ylab = "",zlab = "")
legend3d("right", legend = c("Class 1", "Class 2", "Class 3"), 
            col = 1:3, pch = 20)
}
#Perform the clustering algorithm with number od clusters k=3.
pkbd<- pkbc(dat, 3)

}
\references{
Golzy, M., Markatou, M. (2020) Poisson Kernel-Based Clustering on the Sphere:
Convergence Properties, Identifiability, and a Method of Sampling, Journal of
Computational and Graphical Statistics, 29:4, 758-770,
DOI: 10.1080/10618600.2020.1740713.
}
