% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_splitSample_dichotom.R
\name{optim_splitSample_dichotom}
\alias{optim_splitSample_dichotom}
\title{Selection of an Optimal Dichotomous Predictor via Repeated Sample Splits}
\usage{
optim_splitSample_dichotom(formula, data, include, top = 3L, nsplit, ...)
}
\arguments{
\item{formula}{\link[stats]{formula}.
Left-hand-side is the name of a \link[survival]{Surv}, \link[base]{logical}, or \link[base]{numeric} endpoint.
Right-hand-side is the name of a \link[base]{matrix} predictor.
See details of parameter \code{data}}

\item{data}{\link[base]{data.frame}, with at least
\itemize{
\item {
two columns including the \link[base]{numeric} time-to-event and the \link[base]{logical} event indicator,
or one \link[survival]{Surv} column,
or one \link[base]{logical} column,
or one \link[base]{numeric} column, as the endpoint}
\item {one \link[base]{numeric} \link[base]{matrix} column,
the columns of which are a collection of predictors to be selected from}
}}

\item{include}{\link[base]{language} object,
inclusion criteria for restricting the predictor(s) to guarantee
a user-desired range of proportions in \code{highX}.
A suggested choice is \code{(highX > .15 & highX < .85)}.
See explanation of \code{highX} in \link{splitSample_dichotom}.}

\item{top}{\link[base]{integer} scalar, number of optimal predictors, default \code{3L}}

\item{nsplit, ...}{additional parameters for \link{stratifiedSplitSample}}
}
\value{
\link{optim_splitSample_dichotom} returns a \link[base]{data.frame},
containing only the optimal predictors, with \link[base]{attributes}
\describe{
\item{\code{attr(,'top')}}{a \link[base]{data.frame} with
regression coefficients of dichotomized predictors,
branches,
and proportion \code{highX}}
}
}
\description{
Repeated sample splits are used to (i) determine the optimal cutoff for dichotomizing
each predictor of interest in the training split part and (ii) compute the corresponding
effect size in the test split part.
For each predictor, the effect sizes in test splits are computed for 100-200 splits,
and the optimal predictor is selected with the highest median effect size.
}
\details{
To select an optimal dichotomous predictor via repeated sample splits,

\enumerate{

\item generates \code{nsplit} different sample splits
(via \link{stratifiedSplitSample}) and
stores them in variable \code{splitIDs}

\item finds the median effect size for multiple sample splits
(via \link{median_splitSample_dichotom}) for each predictor,
using the same sample splits \code{splitIDs}.
In this step, we obtain one \link{splitSample_dichotom} object for each predictor

\item (optional) selects a subset of
\link{splitSample_dichotom} objects obtained from Step 2 (one for each predictor),
based on the inclusion criteria specified in parameter \code{include}.
Typically, we restrict the predictor(s) to guarantee
a user-desired range of proportions for \code{highX} (see \emph{Value} section of \link{splitSample_dichotom}).
A suggested choice is \code{(highX > .15 & highX < .85)}.

\item ranks the \link{splitSample_dichotom} objects,
obtained from Step 2 or Step 3,
by the decreasing order of the absolute values (\link[base]{abs}) of
the regression coefficients of dichotomized predictors \code{attr(, 'coef')}.
The predictor(s) corresponding to the \link{splitSample_dichotom} object(s)
with largest absolute value(s) of the regression coefficients of dichotomized predictors,
are referred to as the optimal predictor(s).

}
}
\examples{
# see ?`Qindex-package`

}
