% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.band.cq.R
\name{make.band.cq}
\alias{make.band.cq}
\title{Uniform confidence bands for conditional quantile processes}
\usage{
make.band.cq(n.sam,Dc.p,Dc.m,Dr.p,Dr.m,dz,cov,taus,hh,Qy.p,Qy.m,
     bias.p,bias.m,alpha,n.sim)
}
\arguments{
\item{n.sam}{the sample size.}

\item{Dc.p}{simulated values from \eqn{D_{1,v}(x_{0}^{+},z,\tau)}.}

\item{Dc.m}{simulated values from \eqn{D_{1,v}(x_{0}^{-},z,\tau)}.}

\item{Dr.p}{simulated values from \eqn{D_{1,v}(x_{0}^{+},z,\tau) - D_{2,v}(x_{0}^{+},z,\tau)}.}

\item{Dr.m}{simulated values from \eqn{D_{1,v}(x_{0}^{-},z,\tau) - D_{2,v}(x_{0}^{-},z,\tau)}.}

\item{dz}{the number of covariates.}

\item{cov}{either 0 or 1. Set \emph{cov=1} if covariates are present in the model;
otherwise set \emph{cov=0}.}

\item{taus}{a vector of quantiles of interest.}

\item{hh}{the bandwidth values.}

\item{Qy.p}{estimated conditional quantiles at \eqn{(x_{0}^{+},z)}.}

\item{Qy.m}{estimated conditional quantiles at \eqn{(x_{0}^{-},z)}.}

\item{bias.p}{estimated bias terms at \eqn{(x_{0}^{+},z)}.}

\item{bias.m}{estimated bias terms at \eqn{(x_{0}^{-},z)}.}

\item{alpha}{a number between 0 and 1, the desired significance level.}

\item{n.sim}{the number of simulation repetitions.}
}
\value{
A list with elements:
\describe{
\item{qp}{conditional quantile estimates at \eqn{x_{0}^{+}} (i.e., above the cutoff) without bias correction.}
\item{qp.r}{bias corrected conditional quantile estimates at \eqn{x_{0}^{+}}.}
\item{qm}{conditional quantile estimates at \eqn{x_{0}^{-}} (i.e., below the cutoff) without bias correction.}
\item{qm.r}{bias corrected conditional quantile estimates at \eqn{x_{0}^{-}}.}
\item{ubandp}{uniform confidence band for conditional quantiles at \eqn{x_{0}^{+}}
without bias correction.}
\item{ubandp.r}{uniform confidence band for conditional quantiles at \eqn{x_{0}^{+}}
with robust bias correction.}
\item{ubandm}{uniform confidence band for conditional quantiles at \eqn{x_{0}^{-}}
without bias correction.}
\item{ubandm.r}{uniform confidence band for conditional quantiles at \eqn{x_{0}^{-}}
with robust bias correction.}
\item{sp}{standard errors of the conditional quantile estimates without bias correction
at \eqn{x_{0}^{+}}.}
\item{sp.r}{standard errors of the conditional quantile estimates with robust
bias correction at \eqn{x_{0}^{+}}.}
\item{sm}{standard errors of the conditional quantile estimates without bias correction
at \eqn{x_{0}^{-}}.}
\item{sm.r}{standard errors of the conditional quantile estimates with robust
bias correction at \eqn{x_{0}^{-}}.}
}
}
\description{
\code{make.band.cq} constructs uniform confidence bands for conditional quantile processes as functions of tau for each side of the cutoff.
See \code{make.band} as well. The function \code{rdq.band} calls this function to generates uniform bands for conditional quantiles.
}
\examples{
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
tlevel2 = c(0.05,tlevel,0.95)
hh = rep(2,length(tlevel))
hh2 = rep(2,length(tlevel2))
sel = tlevel2 \%in\% tlevel

ab = rdq(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel2,h.tau=hh2,cov=0)
delta = c(0.05,0.09,0.14,0.17,0.19,0.17,0.14,0.09,0.05)
fp = rdq.condf(x=x,Q=ab$qp.est,bcoe=ab$bcoe.p,taus=tlevel,taul=tlevel2,delta,cov=0)
fm = rdq.condf(x=x,Q=ab$qm.est,bcoe=ab$bcoe.m,taus=tlevel,taul=tlevel2,delta,cov=0)
bp = rdq.bias(y[d==1],x[d==1],dz=0,x0=0,z0=NULL,taus=tlevel,hh,hh,fx=fp$ff[(d==1),],cov=0)
bm = rdq.bias(y[d==0],x[d==0],dz=0,x0=0,z0=NULL,taus=tlevel,hh,hh,fx=fm$ff[(d==0),],cov=0)

sa = rdq.sim(x=x,d=d,x0=0,z0=NULL,dz=0,cov=0,tt=tlevel,hh,hh,fxp=fp$ff,fxm=fm$ff,n.sim=200)
ba.cq = make.band.cq(n,Dc.p=sa$dcp,Dc.m=sa$dcm,Dr.p=sa$drp,Dr.m=sa$drm,dz=0,cov=0,
taus=tlevel,hh,Qy.p=as.matrix(ab$qp.est[sel,]),Qy.m=as.matrix(ab$qm.est[sel,]),
bias.p=bp$bias,bias.m=bm$bias,alpha=0.1,n.sim=200)

}
\seealso{
\link{make.band}
}
