% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wop.R
\name{wop}
\alias{wop}
\title{Weight of partitions for pooled solution parameters
for conservative or parsimonious solution}
\usage{
wop(dataset, units, time, cond, out, n_cut, incl_cut, solution, amb_selector)
}
\arguments{
\item{dataset}{Calibrated pooled dataset for partitioning and minimization
of pooled solution.}

\item{units}{Units that define the within-dimension of data (time series).}

\item{time}{Periods that define the between-dimension of data (cross sections).}

\item{cond}{Conditions used for the pooled analysis.}

\item{out}{Outcome used for the pooled analysis.}

\item{n_cut}{Frequency cut-off for designating truth table rows as observed
in the pooled analysis.}

\item{incl_cut}{Inclusion cut-off for designating truth table rows as
consistent in the pooled analysis.}

\item{solution}{A character specifying the type of solution that should
be derived. \code{C} produces the conservative (or complex) solution,
\code{P} the parsimonious solution. See \code{\link{wop_inter}} for deriving
intermediate solution.}

\item{amb_selector}{Numerical value for selecting a single model in the
presence of model ambiguity. Models are numbered according to their
order produced by \code{\link{minimize}} by the \code{QCA} package.}
}
\value{
A dataframe with information about the weight of the partitions
with the following columns:
\itemize{
\item \code{type}: The type of the partition. \code{between} stands for
cross-sections; \code{within} stands for time series. \code{pooled} stands
information about the pooled data.
\item \code{partition}: Type of partition. For
between-dimension, the unit identifiers are listed  (argument \code{units}).
For the within-dimension, the time identifiers are listed (argument \code{time}).
The entry is \code{-} for the pooled data.
\item \code{denom_cons}: Denominator of the consistency formula. It is the sum
over the cases' membership in the solution.
\item \code{num_cons}: Numerator of the consistency formula. It is the sum
over the minimum of the cases' membership in the solution and the outcome.
\item \code{denom_cov}: Denominator of the coverage formula. It is the sum
over the cases' membership in the outcome.
\item \code{num_cov}: Numerator of the coverage formula. It is the sum
over the minimum of the cases' membership in the solution and the outcome.
(identical to \code{num_cons})
}
}
\description{
\code{wop} calculates the contribution or weight of partitions
for the pooled solution parameters of consistency and coverage
for the conservative or parsimonious solution.
}
\examples{
data(Thiem2011)
wop_pars <- wop(
  dataset = Thiem2011,
  units = "country", time = "year",
  cond = c("fedismfs", "homogtyfs", "powdifffs", "comptvnsfs", "pubsupfs", "ecodpcefs"),
  out = "memberfs",
  n_cut = 6, incl_cut = 0.8,
  solution = "P",
  amb_selector = 1)
wop_pars
}
