% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_trial_data}
\alias{get_trial_data}
\title{Get the Observations Data of the Current Active Trial}
\usage{
get_trial_data()
}
\value{
A data frame of the trial observations data.
}
\description{
Retrieves the observations data of the current active trial (i.e., including 
all studies within) as configured in the internal state object using 
`set_trial()` function.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # Select a specific study/trial by name
  set_trial("IDYT39")

  # Retrieve multi-environment trial data
  MET <- get_trial_data()
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
