% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_program_studies}
\alias{get_program_studies}
\title{Get the list of trials studies locations information of the current selected program}
\usage{
get_program_studies()
}
\value{
a data frame of locations information for each study in the program trials
}
\description{
This function will retrieve all environments/locations information of the trials studies in the
current active program as configured in the internal state object using `set_program()` function.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# retrive all environments/locations information in the selected program studies/trials
program_studies <- get_program_studies()
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
