% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PyObjectDict.R
\name{pyDict}
\alias{pyDict}
\title{Create a virtual Python dictionary}
\usage{
pyDict(key, value, regFinalizer = TRUE)
}
\arguments{
\item{key}{a character string giving the name of the Python object.}

\item{value}{if a value is provided, a new Python dictionary is created based 
on the value. Therefore allowed values of value are named lists and 
names vectors.}

\item{regFinalizer}{a logical indicating if a finalizer should be
be registered, the default value is TRUE.}
}
\description{
The function pyDict creates a virtual Python object 
             of type PythonInR_Dict.
}
\details{
If no value is provided a virtual Python dict for an existing
         Python object is created. If the value is NULL, an empty 
         virtual Python object for an empty dict is created.
         If the value is a named vector or named list, a new Python
         object based on the vector or list is created.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
if ( pyIsConnected() ){
pyExec('myPyDict = {"a":1, "b":2, "c":3}')
## create a virtual Python dictionary for an existing dictionary
myDict <- pyDict("myPyDict")
myDict["a"]
myDict["a"] <- "set the key"
myDict
## allowed keys are
myDict['string'] <- 1
myDict[3L] <- "long"
myDict[5] <- "float"
myDict[c("t", "u", "p", "l", "e")] <- "tuple"
myDict
## NOTE: Python does not make a difference between a float key 3 and a long key 3L
myDict[3] <- "float"
myDict
## create a new Python dict and virtual dict
myNewDict <- pyDict('myNewDict', list(p=2, y=9, r=1))
myNewDict
}
}
