% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.regressionTable.R
\name{summary.regressionTable}
\alias{summary.regressionTable}
\alias{print.summary.regressionTable}
\title{Formatting regression tables}
\usage{
\method{summary}{regressionTable}(object, show.missing = "ifany",
  print = TRUE, ...)
}
\arguments{
\item{object}{object obtained with \code{regressionTable} or \code{summary.regressionTable}.}

\item{show.missing}{Decide if number of missing values are shown.
Either logical or character. If \code{'ifany'} then number missing values are
shown if there are some.}

\item{print}{If \code{TRUE} print results.}

\item{...}{Used to control formatting of parameter estimates,
confidence intervals and p-values. See examples.}
}
\value{
List with two elements:
\itemize{
\item regressionTable: the formatted regression table (a data.frame)
\item rawTable: table with the unformatted values (a data.frame)
}
}
\description{
Preparing regression results for publication
}
\examples{
library(survival)
data(pbc)
pbc$edema <- factor(pbc$edema,levels=c("0","0.5","1"),labels=c("0","0.5","1"))
fit = coxph(Surv(time,status!=0)~age+sex+edema+log(bili)+log(albumin)+log(protime),
            data=pbc)
u=summary(regressionTable(fit))
u$regressionTable
u$rawTable
summary(regressionTable(fit),handler="prettyNum")
summary(regressionTable(fit),handler="format")
summary(regressionTable(fit),handler="sprintf",digits=c(2,2),pValue.stars=TRUE)
summary(regressionTable(fit),handler="sprintf",digits=c(2,2),pValue.stars=TRUE,ci.format="(l,u)")
}
\seealso{
publish.glm publish.coxph
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
