% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_compounds.R
\name{get_compounds}
\alias{get_compounds}
\title{Retrieve Compounds from PubChem}
\usage{
get_compounds(
  identifier,
  namespace = "cid",
  operation = NULL,
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A vector of positive integers (e.g., cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, a single identifier string (e.g., name, smiles, xref; inchi, sdf by POST only) is sufficient.}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey', 'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{operation}{The operation to be performed (default: NULL).}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure', 'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{options}{Additional parameters passed to \code{get_json}.}
}
\value{
An object of class 'PubChemInstanceList' and 'PC_Compounds' containing compound information from the PubChem database.
}
\description{
This function sends a request to the PubChem database to retrieve compound data based on specified parameters.
}
\examples{
compound <- get_compounds(
  identifier = c("aspirin", "ibuprofen", "rstudio"),
  namespace = "name"
)

print(compound)

# Return results for selected compound.
instance(compound, "aspirin")
instance(compound, "rstudio")
# instance(compound, "unknown"). # returns error.

# Extract compound properties for the compound "aspirin".
# Use the 'retrieve()' function to extract specific slots from the compound list.
retrieve(instance(compound, "aspirin"), "props")

}
\seealso{
\link{retrieve}, \link{instance}
}
