% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{get_wordvecs}
\alias{get_wordvecs}
\title{Extract the word vectors of multiple words.}
\usage{
get_wordvecs(
  data,
  words = NULL,
  pattern = NULL,
  plot = FALSE,
  plot.dims = NULL,
  plot.step = 0.05,
  plot.border = "white"
)
}
\arguments{
\item{data}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}

\item{words}{[Option 1] Word strings (\code{NULL}; a single word; a vector of words).}

\item{pattern}{[Option 2] Pattern of regular expression (see \code{\link[stringr:str_subset]{str_subset}}).
If neither \code{words} nor \code{pattern} are specified (i.e., both are \code{NULL}),
then all words in the data will be extracted.}

\item{plot}{Generate a plot to illustrate the word vectors? Defaults to \code{FALSE}.}

\item{plot.dims}{Dimensions to be plotted (e.g., \code{1:100}).
Defaults to \code{NULL} (plot all dimensions).}

\item{plot.step}{Step for value breaks. Defaults to \code{0.05}.}

\item{plot.border}{Color of tile border. Defaults to \code{"white"}.
To remove the border color, set \code{plot.border=NA}.}
}
\value{
A \code{data.table} with words as columns and dimensions as rows.
}
\description{
Extract the word vectors of multiple words,
using either wordlist (a vector of words; using \code{words})
or regular expression (a pattern of words; using \code{pattern}).
If both the \code{words} and \code{pattern} arguments are specified, \code{words} wins.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = as_wordvec(demodata, normalize=TRUE)

get_wordvecs(d, c("China", "Japan", "Korea"))
get_wordvecs(d, cc(" China, Japan; Korea "))

## specify `pattern`:
get_wordvecs(d, pattern="Chin[ae]|Japan|Korea")

## plot word vectors:
get_wordvecs(d, cc("China, Japan, Korea,
                    Mac, Linux, Windows"),
             plot=TRUE, plot.dims=1:100)

\donttest{## a more complex example:

words = cc("
China
Chinese
Japan
Japanese
good
bad
great
terrible
morning
evening
king
queen
man
woman
he
she
cat
dog
")

dt = get_wordvecs(
  d, words,
  plot=TRUE,
  plot.dims=1:100,
  plot.step=0.06)

# if you want to change something:
attr(dt, "ggplot") +
  scale_fill_viridis_b(n.breaks=10, show.limits=TRUE) +
  theme(legend.key.height=unit(0.1, "npc"))

# or to save the plot:
ggsave(attr(dt, "ggplot"),
       filename="wordvecs.png",
       width=8, height=5, dpi=500)
unlink("wordvecs.png")  # delete file for code check
}
}
\seealso{
\code{\link{get_wordvec}}

\code{\link{plot_wordvec}}

\code{\link{plot_wordvec_tSNE}}
}
