## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
S<-matrix(c(1,1,1,0,0,1),3,2, byrow = TRUE)
S

## -----------------------------------------------------------------------------
y<-matrix(NA,3,10) #preallocate matrix
for (t in 1:10){
  y[,t]<-S%*%(c(1,1)+rnorm(2))
}


## -----------------------------------------------------------------------------
yhat<-matrix(runif(30),3,10)

## -----------------------------------------------------------------------------
library(ProbReco)
out<-inscoreopt(y=y,yhat=yhat,S=S)
out$d
out$G

## ----loadpkgs-----------------------------------------------------------------
library(purrr)

## -----------------------------------------------------------------------------
data<-map(1:10,function(i){S%*%(c(1,1)+rnorm(2))})
data[[1]]
data[[5]]

## -----------------------------------------------------------------------------
#Function
f<-function(){matrix(rnorm(50*3),3,50)}
prob<-map(1:10,function(i){f})
prob[[1]]
prob[[5]]

## -----------------------------------------------------------------------------
Gvec<-runif(8)
Gvec

## -----------------------------------------------------------------------------
checkinputs(data,prob,S,Gvec)

## -----------------------------------------------------------------------------
out<-total_score(data,prob,S,Gvec)
out$value
out$grad

## -----------------------------------------------------------------------------
out2<-total_score(data,prob,S,Gvec)
out$value
out2$value
out$grad
out2$grad

## -----------------------------------------------------------------------------
out<-scoreopt(data,prob,S)

## -----------------------------------------------------------------------------
out$d
out$G
out$val

## -----------------------------------------------------------------------------
S%*%out$d

## -----------------------------------------------------------------------------
S%*%out$G%*%t(out$G)%*%t(S)

