% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recod.R
\name{recod}
\alias{recod}
\title{Factor recoding}
\usage{
recod(data, name.fact, cod)
}
\arguments{
\item{data}{A data frame containing the observations}

\item{name.fact}{A string. The name of the column containing the factor to be recoded}

\item{cod}{A string. The letter that will appear before the numbers in the new code. For e.g.: "G01"}
}
\value{
The function returns the same data frame, but with a new column
with the prefix "cod." containing the recoded levels
}
\description{
The functions of \code{ProbBreed} works with alphanumeric factors (for e.g., "G01").
\code{recod} was built to perform the recoding of a factor's levels in the dataset. It
adds a new column with the newly coded levels, keeping the original names for
reference.
}
\examples{
toy = data.frame(
            gen = rep(1:5, each =4),
            env = rep(1:4, times = 5),
            y = rnorm(20, mean = 20, sd = 5)
        )
new.toy = recod(toy, name.fact = 'gen', cod = 'G')
toy
}
