% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{nybbleToSignedInt}
\alias{nybbleToSignedInt}
\title{Get signed integer values from nybbles}
\usage{
nybbleToSignedInt(raw_dat, which = c("low", "high"))
}
\arguments{
\item{raw_dat}{\code{raw} data (either a single value or a \code{vector}),
from which a nybble will be extracted and converted.}

\item{which}{A \code{character} string indicating whether the "\code{low}" (default)
or "\code{high}" nybble of \code{raw_dat} needs to be converted into a signed
\code{integer}.}
}
\value{
Returns \code{integer} values of the same length as \code{raw_dat},
ranging from -8 up to 7.
}
\description{
Get signed integer values from one or more nybble.
}
\details{
Nybbles are 4 bit values, where each byte (8 bits) holds two nybbles.
A high nybble (left-hand side of a byte) and a low nybble (right-hand
side of a byte). This function extracts a nybble from \code{raw} data
and converts it into a signed \code{integer} value ranging from -8 up to 7.
}
\examples{
## generate some raw data:

rdat <- as.raw(255*runif(100))

## get signed integers of low nybbles:

sintl <- nybbleToSignedInt(rdat)

## get signed integers of high nybbles:

sinth <- nybbleToSignedInt(rdat, "high")

}
\seealso{
Other nybble.functions: \code{\link{nybble}},
  \code{\link{signedIntToNybble}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{nybble}}, \code{\link{rawToCharNull}},
  \code{\link{rawToPTModule}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}

Other integer.operations: \code{\link{nybble}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}, \code{\link{waveform}}
}
\author{
Pepijn de Vries
}
