% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07PTBlock.r
\docType{methods}
\name{pasteBlock}
\alias{pasteBlock}
\alias{pasteBlock,PTPattern,matrix,numeric,numeric-method}
\title{Paste a block of PTCell data into a PTPattern}
\usage{
\S4method{pasteBlock}{PTPattern,matrix,numeric,numeric}(pattern, block,
  row.start, track.start)
}
\arguments{
\item{pattern}{A \code{\link{PTPattern}} object into which the \code{block}
needs to be pasted.}

\item{block}{A \code{\link{PTBlock}} holding the \code{\link{PTCell}} data
that needs to be pasted into the \code{pattern}.}

\item{row.start}{A positive \code{integer} value (ranging from 1 up to 64)
indicating the starting position (row) in the \code{pattern} to paste the
\code{block} into.}

\item{track.start}{A positive \code{integer} value (ranging from 1 up to 4)
indicating the starting position (track) in the \code{pattern} to paste the
\code{block} into.}
}
\value{
Returns a copy of \code{pattern} into which \code{block} is pasted.
}
\description{
Paste a block of \code{\link{PTCell}} data into a \code{\link{PTPattern}} at
a specified location.
}
\details{
A \code{\link{PTBlock}} is not a formal S4 class. It is a \code{matrix} where
each element holds a \code{list} of a single \code{\link{PTCell}} object. As
explained at the \code{\link{PTBlock}} method documentation, this allows for
a flexible approach of manipulating \code{\link{PTCell}} objects. The
\code{pasteBlock} method allows you to paste a \code{\link{PTBlock}} back into
a \code{\link{PTPattern}}.

The \code{\link{PTBlock}} will be pasted at the specified location and will
span the number of tracks and rows that are included in the \code{\link{PTBlock}}.
The \code{\link{PTCell}}s in the \code{pattern} will be replaced by those
of the \code{block}. Elements of the \code{bock} that are out of the range
of the \code{pattern} are not included in the \code{pattern}.
}
\examples{
data("mod.intro")

block <- PTBlock(PTPattern(mod.intro, 1), 1:16, 1)

## Do some operations using lapply (the effect
## code is set to "C10"):
block <- matrix(lapply(block, function(x) {(effect(x) <- "C10"); x}),
                nrow(block), ncol(block), byrow = TRUE)

## Paste block back on the same position:
PTPattern(mod.intro, 1) <-
  pasteBlock(PTPattern(mod.intro, 1), block, 1, 1)

## You can also paste the block anywhere you like:
PTPattern(mod.intro, 1) <-
  pasteBlock(PTPattern(mod.intro, 1), block, 49, 2)

}
\author{
Pepijn de Vries
}
\seealso{
Other block.operations: \code{\link{PTBlock}}

Other pattern.operations: \code{\link{PTPattern-class}},
  \code{\link{PTPattern-method}},
  \code{\link{appendPattern}}, \code{\link{deletePattern}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}
}

