% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.sgpv.R
\name{plot.sgpv}
\alias{plot.sgpv}
\title{\code{plot.sgpv}: Plot variable selection results}
\usage{
\method{plot}{sgpv}(x, lpv = 3, lambda.max = NULL, short.label = T, ...)
}
\arguments{
\item{x}{An \code{sgpv} object}

\item{lpv}{Lines per variable. It can take the value of 1 meaning that only the
bound that is closest to the null will be plotted, or the value of 3 meaning that
point estimates as well as 95\% confidence interval will be plotted. Default is 3.}

\item{lambda.max}{The maximum lambda on the plot. Default is \code{NULL}.}

\item{short.label}{An indicator if a short label is used for each variable for
better visualization. Default is \code{TRUE}}

\item{...}{Other \code{plot} arguments}
}
\description{
S3 method \code{plot} for an object of class \code{sgpv}. When the two-stage
algorithm is used, this function plots the fully relaxed lasso solution path on
the standardized scale and the final variable selection results. When the
one-stage algorithm is used, a histogram of all coefficients with selected effects
is shown.
}
\examples{

# prepare the data
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

# one-stage algorithm
out.sgpv.1 <- pro.sgpv(x = x, y = y, stage = 1)

# plot the selection result

plot(out.sgpv.1)

# two-stage algorithm
out.sgpv.2 <- pro.sgpv(x = x, y = y)

# plot the fully relaxed lasso solution path and final solution
plot(out.sgpv.2)

# zoom in a little bit
plot(out.sgpv.2, lambda.max = 0.01)

# only plot one confidence bound
plot(out.sgpv.2, lpv = 1, lambda.max = 0.01)
}
