% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_electioneering_communications_by_date.R
\name{get_electioneering_communications_by_date}
\alias{get_electioneering_communications_by_date}
\title{Get Electioneering Communications by Date}
\usage{
get_electioneering_communications_by_date(cycle = 2018, year, month, day,
  myAPI_Key)
}
\arguments{
\item{cycle}{The election cycle}

\item{year}{The four-digit year from 2008-2016.}

\item{month}{The two-digit month from 01-12}

\item{day}{The two-digit day from 01-31}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves all broadcast advertisements that identify one or more federal candidates (and have aired 30 days before a primary election and 60 days before the general election) from a specific date.
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/electioneering_communications/{year}/{month}/{day}
}
\examples{
\donttest{
get_electioneering_communications_by_date(2016, 2012, '10', '01')
}
}
