% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/topology.R
\name{topology}
\alias{topology}
\title{Network topology analysis}
\usage{
topology(graph, simple.parameters = FALSE, degree.distribution = FALSE,
  power.law = TRUE, fit.line = FALSE, clustering.coefficient = FALSE,
  betweenness = FALSE, shortest.paths = FALSE, closeness = FALSE,
  eigenvector.centrality = FALSE, connectivity = FALSE)
}
\arguments{
\item{graph}{An igraph object.}

\item{simple.parameters}{Logical value, indicating whether to do basic statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{degree.distribution}{Logical value, indicating whether to do degree distribution statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{power.law}{Logical value, indicating whether the log ratio would be calculated in degree distribution statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{fit.line}{Logical value, indicating whether to do line fitting in degree distribution statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{clustering.coefficient}{Logical value, indicating whether to do clustering.coefficient statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{betweenness}{Logical value, indicating whether to do betweenness statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{shortest.paths}{Logical value, indicating whether to do shortest.paths statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{closeness}{Logical value, indicating whether to do closeness statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{eigenvector.centrality}{Logical value, indicating whether to do eigenvector.centrality statistics (if \code{TRUE}) or not (if \code{FALSE}).}

\item{connectivity}{Logical value, indicating whether to do connectivity statistics (if \code{TRUE}) or not (if \code{FALSE}).}
}
\value{
A list of topological parameters and plots.
}
\description{
Calculate the network or graph's topological parameters like degree distribution, clustering coefficient, betweenness, closeness, shortest paths, eigenvector centrality and connectivity.
}
\examples{
nlocal<-data.frame(c("DVL1","DVL2","DVL3"))
net<-construction(input=nlocal,db="HPRD",species="human",ID.type="Gene symbol",hierarchy=1)
tp<-topology(net,simple.parameters=TRUE)
tp<-topology(net,degree.distribution=TRUE)
tp<-topology(net,simple.parameters=TRUE,degree.distribution=TRUE)
}
\references{
Y Benjamini, Y Hochberg. Controlling the False Discovery Rate: A Practical and Powerful Approach to Multiple Testing. Journal of the Royal Statistical Society. Series B (Methodological), Vol. 57, No. 1. (1995), pp. 289-300.
}

