% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/enrichment.annotation.R
\name{enrichment.annotation}
\alias{enrichment.annotation}
\title{GO enrichment annotation}
\usage{
enrichment.annotation(data, onto = c("MF", "BP", "CC"), pvalue = 0.05)
}
\arguments{
\item{data}{An igraph object or vector of vertex names.}

\item{onto}{GO categories, three possible values are \code{MF} for GO function, \code{BP} for GO process, and \code{CC} for GO componet}

\item{pvalue}{Significant level. Default value is \code{0.05}.}
}
\value{
Numeric vector, pvalue with the length as the size of data.
}
\description{
GO enrichment annotation of the functional molecules or networks.
}
\examples{
entrez<-data.frame(c("121549","51160","83878","11338","196477","9319","608","7015"))
net<-construction(input=entrez,hierarchy=0,species="human",db="Biogrid",ID.type="Entrez Gene")
res<-enrichment.annotation(net,pvalue=0.05,onto="CC")
}
\references{
The Gene Ontology Consortium (January 2008). The Gene Ontology project in 2008. Nucleic Acids Res. 36 (Database issue): D440?C4.
}

