% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{summary.Bayes.PrevMap}
\alias{summary.Bayes.PrevMap}
\title{Summarizing Bayesian model fits}
\usage{
\method{summary}{Bayes.PrevMap}(object, hpd.coverage = 0.95, ...)
}
\arguments{
\item{object}{an object of class "Bayes.PrevMap" obatained as result of a call to \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}

\item{hpd.coverage}{value of the coverage of the high posterior density intervals; default is \code{0.95}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list with the following values

\code{linear}: logical value that is \code{TRUE} if a linear model was fitted and \code{FALSE} otherwise.

\code{binary}: logical value that is \code{TRUE} if a binary model was fitted and \code{FALSE} otherwise.

\code{probit}: logical value that is \code{TRUE} if a binary model with probit link function was fitted and \code{FALSE} if with logistic link function.

\code{ck}: logical value that is \code{TRUE} if a low-rank approximation was fitted and \code{FALSE} otherwise.

\code{beta}: matrix of the posterior summaries for the regression coefficients.

\code{sigma2}: vector of the posterior summaries for \code{sigma2}.

\code{phi}: vector of the posterior summaries for \code{phi}.

\code{tau2}: vector of the posterior summaries for \code{tau2}.

\code{call}: matched call.

\code{kappa}: fixed value of the shape paramter of the Matern covariance function.
}
\description{
\code{summary} method for the class "Bayes.PrevMap" that computes the posterior mean, median, mode and high posterior density intervals using samples from Bayesian fits.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

