% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotData.R
\name{PlotData}
\alias{PlotData}
\title{Plot Rainfall and Potential Evapotranspiration Data}
\usage{
PlotData(lon, lat, start.date, end.date)
}
\arguments{
\item{lon}{longitude in decimal degrees: (+) Eastern Hemisphere (-) Western Hemisphere.}

\item{lat}{latitude in decimal degrees: (+) Northern Hemisphere (-) Southern Hemisphere.}

\item{start.date}{date at which the indices estimates should start ("YYYY-MM-DD").}

\item{end.date}{date at which the indices estimates should end ("YYYY-MM-DD").}
}
\value{
No return value, called for side effects. Using this will display scatter
  plots of rainfall and potential evapotranspiration accumulated at the
  1-quart.month time scale in the active \R session.
}
\description{
Plots rainfall and potential evapotranspiration, both Penman-Monteith and
  Hargreaves and Samani, amounts using \acronym{NASA} \acronym{POWER} data.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# This example requires an Internet connection to fetch data and so is only
# run in interactive sessions

PlotData(
  lon = -47.3,
  lat = -22.87,
  start.date = "2021-12-28",
  end.date = "2022-12-31"
)
\dontshow{\}) # examplesIf}
}
