% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PosteriorBootstrap.R
\name{draw_stick_breaks}
\alias{draw_stick_breaks}
\title{Draw stick-breaks depending on a concentration parameter}
\usage{
draw_stick_breaks(
  concentration = 1,
  min_stick_breaks = 100,
  threshold = 1e-08,
  seed = NULL
)
}
\arguments{
\item{concentration}{The parameter \code{c} in the paper (page 3, formula 3),
which is an effective sample size.}

\item{min_stick_breaks}{The minimal number of stick-breaks.}

\item{threshold}{The threshold of stick remaining below which the function
stops looking for more stick-breaks. It corresponds to epsilon in the
paper, at the bottom of page 5 and in algorithm 2 in page 12.}

\item{seed}{A seed to start the sampling.}
}
\value{
A vector of stick-breaks summing to one.
}
\description{
\code{draw_stick_breaks} returns a vector with the breaks of a stick of
length 1.
}
\details{
This function implements the stick-breaking process for non-parametric
learning described in section 2 of the supplementary material. The name
"stick-breaking" comes from a stick of unit length that we need to break into
a number of items. This code implements algorithm 2 and the stick-breaking
function calculates the parameter T in algorithm 1, which is the only
difference between the two algorithms. The code uses the Beta distribution as
that distribution is part of the definition of the stick-breaking process.
The function draws from the beta distribution, e.g. \code{b_1}, \code{b_2},
\code{b_3}, ..., and computes the stick breaks as \code{b_1},
\code{(1-b_1)*b_2}, \code{(1-b_1)*(1-b_2)*b_3}, ... . The length remaining in
the stick at each step is \code{1-b_1}, \code{(1-b_1)* (1-b_2)},
\code{(1-b_1)*(1-b_2)*(1-b_3)}, ... so the latter converges to zero.
}
\examples{
draw_stick_breaks(1)
draw_stick_breaks(1, min_stick_breaks = 10)
draw_stick_breaks(1, min_stick_breaks = 10, threshold = 1e-8)

}
