/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openfast.Context;
import org.openfast.Global;
import org.openfast.Message;
import org.openfast.MessageBlockWriter;
import org.openfast.MessageHandler;
import org.openfast.MessageStream;
import org.openfast.codec.FastEncoder;
import org.openfast.error.FastConstants;
import org.openfast.logging.FastMessageLogger;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegistry;

public class MessageOutputStream
implements MessageStream {
    private final OutputStream out;
    private final FastEncoder encoder;
    private final Context context;
    private List handlers = Collections.EMPTY_LIST;
    private Map templateHandlers = Collections.EMPTY_MAP;
    private MessageBlockWriter blockWriter = MessageBlockWriter.NULL;

    public MessageOutputStream(OutputStream outputStream) {
        this(outputStream, new Context());
    }

    public MessageOutputStream(OutputStream outputStream, Context context) {
        this.out = outputStream;
        this.encoder = new FastEncoder(context);
        this.context = context;
    }

    public void writeMessage(Message message) {
        this.writeMessage(message, false);
    }

    public void writeMessage(Message message, boolean flush) {
        try {
            byte[] data = this.encodeMessage(message);
            if (data == null || data.length == 0) {
                return;
            }
            this.blockWriter.writeBlockLength(this.out, message, data);
            this.out.write(data);
            if (flush) {
                this.out.flush();
            }
            this.getContext().getLogger().log(message, data, FastMessageLogger.Direction.OUTBOUND);
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "An IO error occurred while writing message " + message, e);
        }
    }

    private byte[] encodeMessage(Message message) {
        if (this.context.isTraceEnabled()) {
            this.context.startTrace();
        }
        if (!this.handlers.isEmpty()) {
            int i = 0;
            while (i < this.handlers.size()) {
                ((MessageHandler)this.handlers.get(i)).handleMessage(message, this.context, this.encoder);
                ++i;
            }
        }
        if (this.templateHandlers.containsKey(message.getTemplate())) {
            ((MessageHandler)this.templateHandlers.get(message.getTemplate())).handleMessage(message, this.context, this.encoder);
        }
        return this.encoder.encode(message);
    }

    public void reset() {
        this.encoder.reset();
    }

    public void registerTemplate(int templateId, MessageTemplate template) {
        this.encoder.registerTemplate(templateId, template);
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "An error occurred while closing output stream.", e);
        }
    }

    public OutputStream getUnderlyingStream() {
        return this.out;
    }

    public void addMessageHandler(MessageTemplate template, MessageHandler handler) {
        if (this.templateHandlers == Collections.EMPTY_MAP) {
            this.templateHandlers = new HashMap();
        }
        this.templateHandlers.put(template, handler);
    }

    public void addMessageHandler(MessageHandler handler) {
        if (this.handlers == Collections.EMPTY_LIST) {
            this.handlers = new ArrayList(4);
        }
        this.handlers.add(handler);
    }

    public void setTemplateRegistry(TemplateRegistry registry) {
        this.context.setTemplateRegistry(registry);
    }

    public void setBlockWriter(MessageBlockWriter blockWriter) {
        this.blockWriter = blockWriter;
    }

    public TemplateRegistry getTemplateRegistry() {
        return this.context.getTemplateRegistry();
    }

    public Context getContext() {
        return this.context;
    }
}

