/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import org.openfast.ByteUtil;

public class BitVector {
    private static final int VALUE_BITS_SET = 127;
    private static final int STOP_BIT = 128;
    private byte[] bytes;
    private int size;

    public BitVector(int size) {
        this(new byte[(size - 1) / 7 + 1]);
    }

    public BitVector(byte[] bytes) {
        this.bytes = bytes;
        this.size = bytes.length * 7;
        int n = bytes.length - 1;
        bytes[n] = (byte)(bytes[n] | 0x80);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getTruncatedBytes() {
        int index = this.bytes.length - 1;
        while (index > 0 && (this.bytes[index] & 0x7F) == 0) {
            --index;
        }
        if (index == this.bytes.length - 1) {
            return this.bytes;
        }
        byte[] truncated = new byte[index + 1];
        System.arraycopy(this.bytes, 0, truncated, 0, index + 1);
        int n = truncated.length - 1;
        truncated[n] = (byte)(truncated[n] | 0x80);
        return truncated;
    }

    public int getSize() {
        return this.size;
    }

    public void set(int fieldIndex) {
        int n = fieldIndex / 7;
        this.bytes[n] = (byte)(this.bytes[n] | 1 << 6 - fieldIndex % 7);
    }

    public boolean isSet(int fieldIndex) {
        if (fieldIndex >= this.bytes.length * 7) {
            return false;
        }
        return (this.bytes[fieldIndex / 7] & 1 << 6 - fieldIndex % 7) > 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BitVector)) {
            return false;
        }
        return this.equals((BitVector)obj);
    }

    public boolean equals(BitVector other) {
        if (other.size != this.size) {
            return false;
        }
        int i = 0;
        while (i < this.bytes.length) {
            if (this.bytes[i] != other.bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    public boolean isOverlong() {
        return this.bytes.length > 1 && (this.bytes[this.bytes.length - 1] & 0x7F) == 0;
    }

    public String toString() {
        return "BitVector [" + ByteUtil.convertByteArrayToBitString(this.bytes) + "]";
    }

    public int indexOfLastSet() {
        int index = this.bytes.length * 7 - 1;
        while (index >= 0 && !this.isSet(index)) {
            --index;
        }
        return index;
    }
}

