/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio.optimizer;

import com.google.gson.Gson;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.result.MethodResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PortfolioOptimizer {
    private static final String METRIC_PORTFOLIO_OPTIMIZATION = "{\"metric\":\"PORTFOLIO_OPTIMIZATION\"}";
    protected Portfolio portfolio;
    protected String paramsString = "";
    protected ArrayList<HashMap<String, String>> paramsBuffer = new ArrayList();
    private int constraintNumber = 0;
    private static AtomicLong constrainCount = new AtomicLong();
    private double errorInDecimalPoints;
    private double globalOptimumProbability;
    private int portfolioValue = -1;

    public PortfolioOptimizer(Portfolio portfolio) {
        this(portfolio, 1.0E-12, 0.99);
    }

    public PortfolioOptimizer(Portfolio portfolio, double errorInDecimalPoints, double globalOptimumProbability) {
        this.portfolio = portfolio;
        this.errorInDecimalPoints = errorInDecimalPoints;
        this.globalOptimumProbability = globalOptimumProbability;
    }

    public void setOptimizationGoal(String optimizationMetric, String direction) {
        HashMap<String, String> sb = this.populateRequiredOptimizationGoalParams(optimizationMetric, direction);
        sb.put("confidenceInterval", "0.95");
        this.setOptimizationGoal(sb);
    }

    public void setOptimizationGoal(String optimizationMetric, String direction, double confidenceInterval) {
        HashMap<String, String> sb = this.populateRequiredOptimizationGoalParams(optimizationMetric, direction);
        sb.put("confidenceInterval", "" + confidenceInterval);
        this.setOptimizationGoal(sb);
    }

    private HashMap<String, String> populateRequiredOptimizationGoalParams(String optimizationMetric, String direction) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("optimizationMetric", optimizationMetric);
        sb.put("direction", direction);
        return sb;
    }

    private void setOptimizationGoal(HashMap<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "GOAL");
        map.putAll(params);
        map.put("localOptimStopStep", "" + this.errorInDecimalPoints);
        map.put("globalOptimProbability", "" + this.globalOptimumProbability);
        this.paramsBuffer.add(map);
    }

    public void addPortfolioConstraint(String constraintName, double expectedValue) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("constraintName", constraintName);
        sb.put("expectedValue", "" + expectedValue);
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, double[] expectedValues, long[] timeMilliSec) {
        HashMap<String, String> sb = new HashMap<String, String>();
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        sb.put("constraintName", constraintName);
        sb.put("expectedValueDataName", userDataName);
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, String[] positions) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("constraintName", constraintName);
        if (positions.length != 0) {
            String positionList = "";
            for (String e : positions) {
                positionList = positionList + e + "---";
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec, double confidenceInterval) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMilliSec, confidenceInterval, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, double confidenceInterval) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, confidenceInterval, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, 0.95, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMillisec) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMillisec, 0.95, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, double confidenceInterval, String position) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, confidenceInterval, new String[]{position});
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMillisec, double confidenceInterval, String position) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMillisec, confidenceInterval, new String[]{position});
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, String[] positions) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, 0.95, positions);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMillisec, String[] positions) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMillisec, 0.95, positions);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, double confidenceInterval, String[] positions) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("constraintName", constraintName);
        sb.put("constraintType", constraintType);
        sb.put("confidenceInterval", "" + confidenceInterval);
        sb.put("expectedValue", "" + expectedValue);
        sb.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
        if (positions.length != 0) {
            String positionList = "";
            for (String e : positions) {
                positionList = positionList + e + "---";
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec, double confidenceInterval, String[] positions) {
        HashMap<String, String> sb = new HashMap<String, String>();
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        sb.put("constraintName", constraintName);
        sb.put("constraintType", constraintType);
        sb.put("confidenceInterval", "" + confidenceInterval);
        sb.put("expectedValueDataName", userDataName);
        if (positions.length != 0) {
            String positionList = "";
            for (String e : positions) {
                positionList = positionList + e + "---";
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    private void addPortfolioConstraint(HashMap<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.putAll(params);
        this.paramsBuffer.add(map);
    }

    public String getParamsBuffer() {
        return this.paramsBuffer.toString();
    }

    public void addPositionConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec, String positionName) {
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.put("position", positionName);
        map.put("constraintName", constraintName);
        map.put("constraintType", constraintType);
        map.put("expectedValueDataName", userDataName);
        this.paramsBuffer.add(map);
    }

    public void addPositionConstraint(String constraintName, String constraintType, double expectedValue, String positionName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.put("position", positionName);
        map.put("constraintName", constraintName);
        map.put("constraintType", constraintType);
        map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
        map.put("expectedValue", "" + expectedValue);
        this.paramsBuffer.add(map);
    }

    public void addPositionConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec) {
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        for (String positionName : this.portfolio.getSymbols()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("section", "CONSTRAINT_" + this.constraintNumber++);
            map.put("position", positionName);
            map.put("constraintName", constraintName);
            map.put("constraintType", constraintType);
            map.put("expectedValueDataName", userDataName);
            this.paramsBuffer.add(map);
        }
    }

    public void addPositionConstraint(String constraintName, String constraintType, double expectedValue) {
        for (String positionName : this.portfolio.getSymbols()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("section", "CONSTRAINT_" + this.constraintNumber++);
            map.put("position", positionName);
            map.put("constraintName", constraintName);
            map.put("constraintType", constraintType);
            map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
            map.put("expectedValue", "" + expectedValue);
            this.paramsBuffer.add(map);
        }
    }

    public void addPositionConstraint(String constraintName, String constraintType, double expectedValue, String[] symbols) {
        for (String positionName : symbols) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("section", "CONSTRAINT_" + this.constraintNumber++);
            map.put("position", positionName);
            map.put("constraintName", constraintName);
            map.put("constraintType", constraintType);
            map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
            map.put("expectedValue", "" + expectedValue);
            this.paramsBuffer.add(map);
        }
    }

    public void addPositionConstraint(String constraintName, String positionName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.put("position", positionName);
        map.put("constraintName", constraintName);
        this.paramsBuffer.add(map);
    }

    public MethodResult getOptimizedPortfolio() throws Exception {
        return this.getOptimizedPortfolio(false);
    }

    public MethodResult getOptimizedPortfolio(boolean isResultSelfPortfolio) throws Exception {
        Portfolio optimizedPortfolio;
        try {
            optimizedPortfolio = this.optimizationInit(isResultSelfPortfolio);
        }
        catch (Exception e1) {
            return new MethodResult(e1.getMessage());
        }
        return this.makeOptimization(optimizedPortfolio);
    }

    protected MethodResult makeOptimization(Portfolio optimizedPortfolio) throws Exception {
        MethodResult checkResult = optimizedPortfolio.addUserData("portfolioValue", new double[]{this.portfolioValue}, new long[]{-1L});
        if (checkResult.hasError()) {
            return new MethodResult(checkResult.getErrorMessage());
        }
        MethodResult result = optimizedPortfolio.getMetric(METRIC_PORTFOLIO_OPTIMIZATION, this.paramsString);
        if (!result.hasError()) {
            int nSymbols = optimizedPortfolio.getSymbolNamesList().size();
            try {
                ArrayCache[] quantity = ArrayCache.splitBatchDoubleToInt(result.getDataArrayCache("value"), nSymbols);
                for (int k = 0; k < nSymbols; ++k) {
                    optimizedPortfolio.setPositionQuantity(this.portfolio.getSymbolNamesList().get(k), quantity[k], ArrayCache.copyArrayCacheLong(result.getDataArrayCache("time")));
                }
            }
            catch (IOException e) {
                return this.processException(e);
            }
        } else {
            optimizedPortfolio.getClient().createCallGroup(1);
            return new MethodResult(result.getErrorMessage());
        }
        MethodResult resultOpt = new MethodResult();
        resultOpt.setPortfolio("portfolio", optimizedPortfolio);
        resultOpt.setInfoParams(result.getInfoParams());
        return resultOpt;
    }

    protected Portfolio optimizationInit(boolean isResultSelfPortfolio) throws Exception {
        if (this.portfolio.getSymbolNamesList().size() == 0) {
            throw new Exception("Empty portfolio");
        }
        Portfolio optimizedPortfolio = !isResultSelfPortfolio ? new Portfolio(this.portfolio) : this.portfolio;
        Gson gson = new Gson();
        this.paramsString = gson.toJson(this.paramsBuffer);
        return optimizedPortfolio;
    }

    protected MethodResult processException(IOException e) {
        if (e.getMessage() != null) {
            return new MethodResult(e.getMessage());
        }
        return new MethodResult("Error while working with the local file system");
    }

    public void resetParams() {
        this.paramsString = "";
        this.constraintNumber = 0;
        this.paramsBuffer = new ArrayList();
    }

    public double getErrorInDecimalPoints() {
        return this.errorInDecimalPoints;
    }

    public void setErrorInDecimalPoints(double errorInDecimalPoints) {
        this.errorInDecimalPoints = errorInDecimalPoints;
    }

    public double getGlobalOptimumProbability() {
        return this.globalOptimumProbability;
    }

    public void setGlobalOptimumProbability(double globalOptimumProbability) {
        this.globalOptimumProbability = globalOptimumProbability;
    }

    public int getPortfolioValue() {
        return this.portfolioValue;
    }

    public void setPortfolioValue(int portfolioValue) {
        this.portfolioValue = portfolioValue;
    }
}

