% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.efficient.frontier.R
\name{meanetl.efficient.frontier}
\alias{meanetl.efficient.frontier}
\title{Generate the efficient frontier for a mean-etl portfolio}
\usage{
meanetl.efficient.frontier(portfolio, R, n.portfolios = 25, ...)
}
\arguments{
\item{portfolio}{a portfolio object with constraints and objectives created via \code{\link{portfolio.spec}}}

\item{R}{an xts or matrix of asset returns}

\item{n.portfolios}{number of portfolios to generate the efficient frontier}

\item{\dots}{passthru parameters to \code{\link{optimize.portfolio}}}
}
\value{
a matrix of objective measure values and weights along the efficient frontier
}
\description{
This function generates the mean-ETL efficient frontier of a portfolio
specifying the constraints and objectives. The \code{portfolio} object 
should have two objectives: 1) mean and 2) ES (or ETL or cVaR). If the 
portfolio object does not contain these objectives, they will be added 
using default parameters.
}
\author{
Ross Bennett
}
