% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{read.Happyinf.output}
\alias{read.Happyinf.output}
\title{read the haplotyping results from the Happy-inf output}
\usage{
read.Happyinf.output(file_prefix, dropUnused=TRUE)
}
\arguments{
\item{file_prefix}{the prefix for the output files generated by
Happy-inf (the value of the -o parameter)}

\item{dropUnused}{TRUE (default) if the returned matrix should only contain
rows for haplotypes that are present; if FALSE matrix contains rows for all
possible haplotypes}
}
\value{
a list with 2 items: \cr
$hapdos is a matrix with individuals in columns and haplotypes in rows,
giving the dosages of the haplotypes in each individual (summing to ploidy).
This is the same format as the hapdos components of the inferHaplotypes
results of PolyHaplotyper except that \cr
$stats is a matrix with individuals in rows (matching dosmat) and two rows
named mismatch and ratio.
}
\description{
read the haplotyping results from the Happy-inf output
}
\details{
This function reads the <file_prefix>.stat.dat and
<file_prefix>.stats.dat files. The first contains one row per SNP marker,
grouped per haploblock and <ploidy> columns per individual with the SNP
haplotypes, where SNP alleles are represented as 0 or 1, or NA for unknown.
For one SNP, the <ploidy> alleles in an individual are all known or all
unknown It is possible that of the different SNPs in a haploblock
some are known and some are not; in the conversion to PolyHaplotyper format
all these partially known haplotypes are made unknown.
The latter file has a statistics "mismatch" and "ratio" for each individual /
haploblock combination; for their meaning see the Happyinf readme file.
}
