% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{pedigreeSim2PH}
\alias{pedigreeSim2PH}
\title{convert the PedigreeSim true haplotypes to marker dosages and
haplotype dosages}
\usage{
pedigreeSim2PH(ps_geno, haploblock, indiv=NULL, dropUnused=TRUE)
}
\arguments{
\item{ps_geno}{the filename of a *_genotypes.dat file as produced by
PedigreeSim, or a data.frame read from such a file (with a column marker,
followed by <ploidy> columns per individual with the marker alleles for each
homolog; the names of these columns must be <indivname>_<homolog number>).
ps_geno should not contain missing data (this will be true unless the
PedigreeSim output is midified)}

\item{haploblock}{a list of character vectors. The names are the names of the
haploblocks, the character vectors have the names of the markers in each
haploblock. Haplotype names are constructed from the haploblock names, which
are used as prefixes to which the (zero-padded) haplotype numbers are are
appended with separator '_'.\cr
All markers in haploblock must be present in ps_geno. If haploblock is NULL
only the marker dosages are generated, not the haplotype dosages.}

\item{indiv}{the names of the individuals to be extracted; default NULL: all
individuals in ps_geno. If not NULL, all indiv must be present in ps_geno}

\item{dropUnused}{TRUE (default) if the returned matrix should only contain
rows for haplotypes that are present; if FALSE matrix contains rows for all
possible haplotypes}
}
\value{
a list with 2 items:\cr
$mrkDosage: a matrix of marker dosages in the input format of inferHaplotypes,
with all markers that occur in haploblock, sorted according to haploblock,
and for the selected indiv in the specified order\cr
$haplist: (only if haploblock is not NULL) a list with one element for each
haploblock, similar to the
inferHaplotypes output). Each element is itself a list, with two components:\cr
$hapdos is a matrix with the haplotype dosages for that haploblock for each
individual\cr
$markers:  a vector with the names of
the markers in the haploblock in the output of inferHaplotypes
}
\description{
convert the PedigreeSim true haplotypes to marker dosages and
haplotype dosages
}
\details{
if all alleles are in 0/1, these are kept. If only 2 allele symbols
occur in ps_geno all are converted (alphabetically) to 0/1 in
the same way (e.g. if the alleles are A and B, A -> 0 and B -> 1, even in
markers with only B's). If different allele symbols are used between
markers, per marker the (alphabetically or numerically) lowest -> 0 and
the highest -> 1.
So if more than two different allele symbols occur in ps_geno, and
one marker has only A and another only B alleles, both are converted
to 0's.\cr
in mrkDosage, the dosage of the alleles (converted to) 1 is reported
}
