% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{mergeReplicates}
\alias{mergeReplicates}
\title{merge replicate samples in dosage matrix}
\usage{
mergeReplicates(mrkDosage, replist, solveConflicts=TRUE)
}
\arguments{
\item{mrkDosage}{a dosage matrix with markers in rows and individuals in columns.
row names are marker names, column names are individual names.}

\item{replist}{a list of character vectors, each of which has the sample names
of a set of replicates}

\item{solveConflicts}{if TRUE (default) and there are conflicting dosage
assignments between replicates for the same marker, the one with highest
frequency is used, provided the total freq of other dosages = 1 OR
<= 10\% of the frequency of the most frequent dosage. If
solveConflicts is FALSE and there are conflicting dosages, the consensus for
that marker will be NA}
}
\value{
a version of mrkDosage in which only one column of each set of replicates
is retained; this column (the first in its set as specified in replist)
now has the consensus scores over all replicates. Also, if mrkDosage was a
data.frame, it is converted into a matrix.
}
\description{
merge replicate samples in dosage matrix
}
\details{
This function merges all sets of replicates, each to one column.
The column name of the one retained column is the first one for that set
in replist.\cr
For each set of replicates it calls getConsensusmrkDosage
}
\examples{
# construct a dosage matrix with some missing data:
dosmat <-
 matrix(c(rep(c(3,0,1),3), rep(c(1,1,2),4)), nrow=3,
        dimnames=list(c("mrk1","mrk2","mrk3"),
                      c("a1","a2","a3", "b1","b2","b3","b4")))
ix <- matrix(c(1,1, 3,1, 2,2, 1,3, 2,4, 1,5, 2,6), ncol=2, byrow=TRUE)
dosmat[ix] <- NA
dosmat
# define 2 sets of replicates:
reps <- list(c("a1","a2","a3"), c("b1","b2","b3","b4"))
# merge:
mergeReplicates(mrkDosage=dosmat, replist=reps)
# introduce a conflicting dosage:
dosmat[3,2] <- 2
# merge:
mergeReplicates(mrkDosage=dosmat, replist=reps)
}
