% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{ir_to_plotftir}
\alias{ir_to_plotftir}
\title{Convert `ir` to `PlotFTIR` data format}
\usage{
ir_to_plotftir(ir_data, what = NA)
}
\arguments{
\item{ir_data}{data of class `ir` from `ir` package

données de la classe `ir` du paquet `ir`.}

\item{what}{which samples to convert to `PlotFTIR` format. Defaults to all available spectra.

les échantillons à convertir au format `PlotFTIR`. Par défaut, tous les spectres disponibles}
}
\value{
a data.frame compatible with `PlotFTIR` functions

un data.frame compatible avec les fonctions `PlotFTIR`.
}
\description{
convert data from the `ir` package to a structure that will work with `PlotFTIR`.

convertir les données du paquet `ir` en une structure qui fonctionnera avec `PlotFTIR`.
}
\examples{
if (requireNamespace("ir", quietly = TRUE)) {
  # Convert samples 1 & 4 to PlotFTIR format
  ir_to_plotftir(ir::ir_sample_data, c(1, 4))
}

}
\seealso{
[ir::ir_get_spectrum()] for information on how ir passes out data.
}
