% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_circos.R
\name{VDJ_circos}
\alias{VDJ_circos}
\title{Internal utility for circos functions}
\usage{
VDJ_circos(Adj_matrix, group, grid.col, label.threshold, axis, c.count)
}
\arguments{
\item{Adj_matrix}{Adjacency matrix to be plotted. Rownames and Colnames correspond to genes to be matched and entries determine the weight of the connection between the genes (eg. number of clonotypes expressing these two genes).}

\item{group}{Named list of genes, with list elements corresponding to group-names, and element names being the gene-names. Is generated by VDJ_VJ_usage and VDJ_alpha_beta_Vgene_circos.}

\item{grid.col}{Named list of genes, with list elements corresponding to color and element names being gene-names. If not supplied it is generated randomly within the function. Is also generated by VDJ_VJ_usage and VDJ_alpha_beta_Vgene_circos.}

\item{label.threshold}{Genes are only labeled if the count is larger then the label.threshold. By default all label.threshold = 0 (all genes are labeled).}

\item{axis}{Option to choose the count axis for each gene. "default", "percent" or "max"  possible. Default: "max".}

\item{c.count}{Show clonotype or cell count on Circos plot.}
}
\value{
Returns the Circos plot from input of other functions. Do not run as standalone
}
\description{
Plots a Circos diagram from an adjacency matrix. Uses the Circlize chordDiagram function. Is called by VDJ_clonotype_clusters_circos(), VDJ_alpha_beta_Vgene_circos() and VDJ_VJ_usage_circos() functions or works on its own when supplied with an adjacency matrix.
}
\examples{
\dontrun{
VDJ_circos() #Do not run as standalone. Called by other circos functions
}
}
