% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hyperbola.R
\name{Hyperbola}
\alias{Hyperbola}
\title{R6 class representing a hyperbola}
\description{
A hyperbola is given by two intersecting asymptotes, named
  \code{L1} and \code{L2}, and a point on this hyperbola, named \code{M}.
}
\examples{

## ------------------------------------------------
## Method `Hyperbola$OAB`
## ------------------------------------------------

L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
hyperbola$OAB()

## ------------------------------------------------
## Method `Hyperbola$plot`
## ------------------------------------------------

L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
plot(hyperbola, lwd = 2)
points(t(M), pch = 19, col = "blue")
O <- hyperbola$center()
points(t(O), pch = 19)
draw(L1, col = "red")
draw(L2, col = "red")
vertices <- hyperbola$vertices()
points(rbind(vertices$V1, vertices$V2), pch = 19)
majorAxis <- Line$new(vertices$V1, vertices$V2)
draw(majorAxis, lty = "dashed")
foci <- hyperbola$foci()
points(rbind(foci$F1, foci$F2), pch = 19, col = "green")

## ------------------------------------------------
## Method `Hyperbola$includes`
## ------------------------------------------------

L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
hyperbola$includes(M)

## ------------------------------------------------
## Method `Hyperbola$equation`
## ------------------------------------------------

L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
eq <- hyperbola$equation()
x <- M[1]; y <- M[2]
with(eq, Axx*x^2 + 2*Axy*x*y + Ayy*y^2 + 2*Bx*x + 2*By*y + C)
V1 <- hyperbola$vertices()$V1
x <- V1[1]; y <- V1[2]
with(eq, Axx*x^2 + 2*Axy*x*y + Ayy*y^2 + 2*Bx*x + 2*By*y + C)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{L1}}{get or set the asymptote \code{L1}}

\item{\code{L2}}{get or set the asymptote \code{L2}}

\item{\code{M}}{get or set the point \code{M}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Hyperbola-new}{\code{Hyperbola$new()}}
\item \href{#method-Hyperbola-center}{\code{Hyperbola$center()}}
\item \href{#method-Hyperbola-OAB}{\code{Hyperbola$OAB()}}
\item \href{#method-Hyperbola-vertices}{\code{Hyperbola$vertices()}}
\item \href{#method-Hyperbola-abce}{\code{Hyperbola$abce()}}
\item \href{#method-Hyperbola-foci}{\code{Hyperbola$foci()}}
\item \href{#method-Hyperbola-plot}{\code{Hyperbola$plot()}}
\item \href{#method-Hyperbola-includes}{\code{Hyperbola$includes()}}
\item \href{#method-Hyperbola-equation}{\code{Hyperbola$equation()}}
\item \href{#method-Hyperbola-clone}{\code{Hyperbola$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-new"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Hyperbola} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$new(L1, L2, M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{L1, L2}}{two intersecting lines given as \code{Line} objects, the
asymptotes}

\item{\code{M}}{a point on the hyperbola}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Hyperbola} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-center"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-center}{}}}
\subsection{Method \code{center()}}{
Center of the hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$center()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The center of the hyperbola, i.e. the point where
  the two asymptotes meet each other.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-OAB"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-OAB}{}}}
\subsection{Method \code{OAB()}}{
Parametric equation \eqn{O \pm cosh(t) A + sinh(t) B}
  representing the hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$OAB()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The point \code{O} and the two vectors \code{A} and \code{B}
  in a list.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
hyperbola$OAB()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-vertices"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-vertices}{}}}
\subsection{Method \code{vertices()}}{
Vertices of the hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$vertices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The two vertices \code{V1} and \code{V2} in a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-abce"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-abce}{}}}
\subsection{Method \code{abce()}}{
The numbers \code{a} (semi-major axis, i.e. distance
  from center to vertex),
  \code{b} (semi-minor axis),
  \code{c} (linear eccentricity)
  and \code{e} (eccentricity)
  associated to the hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$abce()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The four numbers \code{a}, \code{b}, \code{c} and \code{e}
  in a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-foci"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-foci}{}}}
\subsection{Method \code{foci()}}{
Foci of the hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$foci()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The two foci \code{F1} and \code{F2} in a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-plot}{}}}
\subsection{Method \code{plot()}}{
Plot hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$plot(add = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{add}}{Boolean, whether to add this plot to the current plot}

\item{\code{...}}{named arguments passed to \code{\link[graphics]{lines}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, called for plotting.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
plot(hyperbola, lwd = 2)
points(t(M), pch = 19, col = "blue")
O <- hyperbola$center()
points(t(O), pch = 19)
draw(L1, col = "red")
draw(L2, col = "red")
vertices <- hyperbola$vertices()
points(rbind(vertices$V1, vertices$V2), pch = 19)
majorAxis <- Line$new(vertices$V1, vertices$V2)
draw(majorAxis, lty = "dashed")
foci <- hyperbola$foci()
points(rbind(foci$F1, foci$F2), pch = 19, col = "green")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-includes"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-includes}{}}}
\subsection{Method \code{includes()}}{
Whether a point belongs to the hyperbola.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$includes(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Boolean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
hyperbola$includes(M)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-equation"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-equation}{}}}
\subsection{Method \code{equation()}}{
Implicit quadratic equation of the hyperbola
\ifelse{html}{\out{A<sub>xx</sub>x<sup>2</sup> + 2A<sub>xy</sub>xy + A<sub>yy</sub>y<sup>2</sup> + 2B<sub>x</sub>x + 2B<sub>y</sub>y + C = 0}}{\eqn{A_{xx} x^2 + 2A_{xy} xy + A_{yy} y^2 + 2B_x x + 2B_y y + C = 0}{A_{xx}*x^2 + 2A_{xy}*x*y + A_{yy}*y^2 + 2B_x*x + 2B_y*y + C = 0}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$equation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The coefficients of the equation in a named list.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{L1 <- LineFromInterceptAndSlope(0, 2)
L2 <- LineFromInterceptAndSlope(-2, -0.5)
M <- c(4, 3)
hyperbola <- Hyperbola$new(L1, L2, M)
eq <- hyperbola$equation()
x <- M[1]; y <- M[2]
with(eq, Axx*x^2 + 2*Axy*x*y + Ayy*y^2 + 2*Bx*x + 2*By*y + C)
V1 <- hyperbola$vertices()$V1
x <- V1[1]; y <- V1[2]
with(eq, Axx*x^2 + 2*Axy*x*y + Ayy*y^2 + 2*Bx*x + 2*By*y + C)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperbola-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperbola-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperbola$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
