% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllipticalArc.R
\name{EllipticalArc}
\alias{EllipticalArc}
\title{R6 class representing an elliptical arc}
\description{
An arc is given by an ellipse (\code{Ellipse} object),
a starting angle and an ending angle. They are respectively named
\code{ell}, \code{alpha1} and \code{alpha2}.
}
\examples{

## ------------------------------------------------
## Method `EllipticalArc$new`
## ------------------------------------------------

ell <- Ellipse$new(c(-4,0), 4, 2.5, 140)
EllipticalArc$new(ell, 45, 90)

## ------------------------------------------------
## Method `EllipticalArc$complementaryArc`
## ------------------------------------------------

ell <- Ellipse$new(c(-4,0), 4, 2.5, 140)
arc <- EllipticalArc$new(ell, 30, 60)
plot(NULL, type = "n", asp = 1, xlim = c(-8,0), ylim = c(-3.2,3.2),
     xlab = NA, ylab = NA)
draw(arc, lwd = 3, col = "red")
draw(arc$complementaryArc(), lwd = 3, col = "green")
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ell}}{get or set the ellipse}

\item{\code{alpha1}}{get or set the starting angle}

\item{\code{alpha2}}{get or set the ending angle}

\item{\code{degrees}}{get or set the \code{degrees} field}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EllipticalArc-new}{\code{EllipticalArc$new()}}
\item \href{#method-EllipticalArc-print}{\code{EllipticalArc$print()}}
\item \href{#method-EllipticalArc-startingPoint}{\code{EllipticalArc$startingPoint()}}
\item \href{#method-EllipticalArc-endingPoint}{\code{EllipticalArc$endingPoint()}}
\item \href{#method-EllipticalArc-isEqual}{\code{EllipticalArc$isEqual()}}
\item \href{#method-EllipticalArc-complementaryArc}{\code{EllipticalArc$complementaryArc()}}
\item \href{#method-EllipticalArc-path}{\code{EllipticalArc$path()}}
\item \href{#method-EllipticalArc-length}{\code{EllipticalArc$length()}}
\item \href{#method-EllipticalArc-clone}{\code{EllipticalArc$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-new"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{EllipticalArc} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$new(ell, alpha1, alpha2, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{the ellipse}

\item{\code{alpha1}}{the starting angle}

\item{\code{alpha2}}{the ending angle}

\item{\code{degrees}}{logical, whether \code{alpha1} and \code{alpha2} are
given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{EllipticalArc} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(-4,0), 4, 2.5, 140)
EllipticalArc$new(ell, 45, 90)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-print"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{EllipticalArc} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-startingPoint"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-startingPoint}{}}}
\subsection{Method \code{startingPoint()}}{
Starting point of the reference elliptical arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$startingPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-endingPoint"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-endingPoint}{}}}
\subsection{Method \code{endingPoint()}}{
Ending point of the reference elliptical arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$endingPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-isEqual"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-isEqual}{}}}
\subsection{Method \code{isEqual()}}{
Check whether the reference elliptical arc equals
  another elliptical arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$isEqual(arc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arc}}{an \code{EllipticalArc} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-complementaryArc"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-complementaryArc}{}}}
\subsection{Method \code{complementaryArc()}}{
Complementary elliptical arc of the reference elliptical arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$complementaryArc()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(-4,0), 4, 2.5, 140)
arc <- EllipticalArc$new(ell, 30, 60)
plot(NULL, type = "n", asp = 1, xlim = c(-8,0), ylim = c(-3.2,3.2),
     xlab = NA, ylab = NA)
draw(arc, lwd = 3, col = "red")
draw(arc$complementaryArc(), lwd = 3, col = "green")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-path"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-path}{}}}
\subsection{Method \code{path()}}{
The reference elliptical arc as a path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$path(npoints = 100L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{npoints}}{number of points of the path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with two columns \code{x} and \code{y} of length
  \code{npoints}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-length"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-length}{}}}
\subsection{Method \code{length()}}{
The length of the elliptical arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number, the arc length.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EllipticalArc-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EllipticalArc-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EllipticalArc$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
