% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R, R/summary.R, R/vcov.R
\name{summaries}
\alias{summaries}
\alias{coef.PlackettLuce}
\alias{summary.PlackettLuce}
\alias{vcov.PlackettLuce}
\title{Plackett-Luce Model Summaries}
\usage{
\method{coef}{PlackettLuce}(object, ref = 1, log = TRUE, type = "all",
  ...)

\method{summary}{PlackettLuce}(object, ref = 1, ...)

\method{vcov}{PlackettLuce}(object, ref = 1, ...)
}
\arguments{
\item{object}{an object of class "PlackettLuce" as returned by
\code{PlackettLuce}.}

\item{ref}{an integer or character string specifying the reference item (for
which log worth will be set to zero). If \code{NULL} the sum of the log worth
parameters is set to zero.}

\item{log}{a logical indicating whether to return parameters on the log scale
with the item specified by \code{ref} set to zero.}

\item{type}{the type of coefficients to return: one of \code{"ties"},
\code{"worth"} or \code{"all"}.}

\item{...}{additional arguments, currently ignored.}
}
\description{
Obtain the coefficients, model summary or coefficient variance-covariance
matrix for a model fitted by \code{PlackettLuce}.
}
\details{
By default, parameters are returned on the log scale, as most suited for
inference. If \code{log = FALSE}, the worth parameters are returned,
constrained to sum to one so that they represent the probability that
the corresponding item comes first in a ranking of all items, given that
first place is not tied.
}
