% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forest_seg.R
\name{Calculate_trees_metrics}
\alias{Calculate_trees_metrics}
\title{Calculate tree and canopy metrics}
\usage{
Calculate_trees_metrics(
  woodpoint,
  a,
  AGB_def,
  Forest_floor,
  plot,
  filename,
  output_path,
  canopy_voxel_size = 0.1,
  min_canopy_height = 1.5,
  coverage_method = "mean_normalized"
)
}
\arguments{
\item{woodpoint}{Wood points (trunks and branches) with cluster attribute}

\item{a}{Original point cloud}

\item{AGB_def}{Non-wood (foliage) points}

\item{Forest_floor}{Forest floor points}

\item{plot}{Plot/output file prefix}

\item{filename}{Original file prefix}

\item{output_path}{Output directory}

\item{canopy_voxel_size}{Voxel size for canopy analysis}

\item{min_canopy_height}{Minimum height for canopy analysis}

\item{coverage_method}{Coverage degree calculation method}
}
\value{
List containing tree metrics, canopy metrics, and file paths
}
\description{
Computes metrics for individual trees and forest canopy from segmented point clouds.
}
