% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugDoseResponseCurve.R
\name{drugDoseResponseCurve}
\alias{drugDoseResponseCurve}
\title{Plot drug response curve of a given drug and a given cell for a list of pSets (objects of the PharmacoSet class).}
\usage{
drugDoseResponseCurve(drug, cellline, pSets = list(),
  legends.label = c("ic50_published", "gi50_published", "auc_published",
  "auc_recomputed", "ic50_recomputed"), ylim, xlim, mycol,
  plot.type = c("Fitted", "Actual", "Both"), summarize.replicates = TRUE)
}
\arguments{
\item{drug}{[string] A drug name for which the drug response curve should be 
plotted. If the plot is desirable for more than one pharmaco set, A unique drug id
should be provided.}

\item{cellline}{[string] A cell line name for which the drug response curve should be 
plotted. If the plot is desirable for more than one pharmaco set, A unique cell id
should be provided.}

\item{pSets}{[list] a list of PharmacoSet objects, for which the function
should plot the curves.}

\item{legends.label}{[vector] A vector of sensitivity measurment types which could 
be any combination of  ic50_published, auc_published, auc_recomputed and auc_recomputed_star.
A legend will be displayed on the top right of the plot which each line of the legend is 
the values of requested sensitivity measerments for one of the requested pSets.
If this parameter is missed no legend would be provided for the plot.}

\item{ylim}{[vector] A vector of two numerical values to be used as ylim of the plot.
If this parameter would be missed c(0,100) would be used as the ylim of the plot.}

\item{xlim}{[vector] A vector of two numerical values to be used as xlim of the plot.
If this parameter would be missed the minimum and maximum comncentrations between all 
the pSets would be used as plot xlim.}

\item{mycol}{[vector] A vector with the same lenght of the pSets parameter which 
will determine the color of the curve for the pharmaco sets. If this parameter is 
missed default colors from Rcolorbrewer package will be used as curves color.}

\item{plot.type}{[character] Plot type which can be the actual one ("Actual") or 
the one fitted by logl logistic regression ("Fitted") or both of them ("Both").
If this parameter is missed by default actual curve is plotted.}

\item{summarize.replicates}{[character] If this parameter is set to true replicates 
are summarized and replicates are plotted individually otherwise}
}
\description{
Given a list of PharmacoSets, the function will plot the drug_response curve,
for a given drug/cell pair. The y axis of the plot is the viability percentage
and x axis is the log transformed concentrations. If more than one pSet is 
provided, a light gray area would show the common concentration range between pSets. 
User can ask for type of sensitivity measurment to be shown in the plot legend.
PharmacoSet object's internal curation slot, or according to matching tables 
provided by the user
}

