% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conductance.R
\name{dyadicLongConverter}
\alias{dyadicLongConverter}
\title{dyadic long format converter}
\usage{
dyadicLongConverter(matrix)
}
\arguments{
\item{matrix}{the win-loss matrix which is the second output from \code{conductance}.}
}
\value{
a dataframe of dyadic level win-loss probability and ranking certainty.
}
\description{
\code{dyadicLongConverter} convert win-loss probability matrix into long format for each dyad
}
\details{
values on the diagonal of the matrix are not included in the converted long-format data.
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find win-loss probability matrix
perm2 <- conductance(confmatrix, 2)
perm2$imputed.conf
perm2$p.hat
dl <- dyadicLongConverter(perm2$p.hat)
}
\seealso{
\code{\link{conductance}}, \code{\link{valueConverter}}, \code{\link{individualDomProb}}
}

