% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{dgmm}
\alias{dgmm}
\title{Calculate the probability of a permutation in a GMM}
\usage{
dgmm(perm, sigma0 = identity.permutation(length(perm)), theta,
  dist.name = "kendall")
}
\arguments{
\item{perm}{permutation whose probability wants to be known}

\item{sigma0}{central permuation of the GMM, by default the identity}

\item{theta}{vector dispersion parameter of the GMM}

\item{dist.name}{optional name of the distance used in the GMM. One of: kendall (default), cayley, hamming}
}
\value{
The probability of sigma in the given GMM
}
\description{
Calculate the probability of a permutation sigma in a GMM of center sigma0,
dispersion parameter theta and under the specified distance
}
\examples{
data <- matrix(c(1,2,3,4, 1,4,3,2, 1,2,4,3), nrow = 3, ncol = 4, byrow = TRUE)
sig <- c(1,2,3,4)
th <- c(0.1, 0.2, 0.3,1)
log.prob <- apply(data,MARGIN=1,FUN=function(x){log(dgmm(x,sig, th, "hamming"))})
sum(log.prob)
dgmm (c(1,2,3,4), theta=c(1,1,1))
dgmm (c(1,2,3,4), theta=c(1,1,1), dist.name="cayley")
}

