% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{decomp2perm}
\alias{decomp2perm}
\title{Get a permutation consistent with a decomposition vector}
\usage{
decomp2perm(vec, dist.name = "kendall")
}
\arguments{
\item{vec}{the permutation}

\item{dist.name}{optional the name of the distance. One of: kendall (default), cayley, hamming}
}
\value{
The distance decomposition vector of the given permutation and distance
}
\description{
Given a distance decomposition vector and a distance name, generate uniformly at random
a permutation consistent with the decomposition vector.
}
\examples{
decomp2perm(c(1,0,1,0,0), "kendall")
decomp2perm(c(1,0,1,0,0), "cayley")
decomp2perm(c(1,0,1,0,0), "hamming")
}

