% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortIntersect.R
\name{addCohortIntersectCount}
\alias{addCohortIntersectCount}
\title{It creates columns to indicate number of occurrences of intersection with a
cohort}
\usage{
addCohortIntersectCount(
  x,
  targetCohortTable,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetStartDate = "cohort_start_date",
  targetEndDate = "cohort_end_date",
  window = list(c(0, Inf)),
  nameStyle = "{cohort_name}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{targetCohortTable}{name of the cohort that we want to check for overlap.}

\item{targetCohortId}{vector of cohort definition ids to include.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x.}

\item{targetStartDate}{date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{window}{window to consider events of.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}
}
\value{
table with added columns with overlap information.
}
\description{
It creates columns to indicate number of occurrences of intersection with a
cohort
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addCohortIntersectCount(
    targetCohortTable = "cohort2"
  )
mockDisconnect(cdm = cdm)
}

}
