% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummarised.R
\name{plotCohortOverlap}
\alias{plotCohortOverlap}
\title{Plot the result of summariseCohortOverlap.}
\usage{
plotCohortOverlap(
  result,
  facetVarX = "variable_name",
  facetVarY = "strata_level",
  colorVars = "variable_level",
  overlapLabel = "{cohort_name_reference} &&& {cohort_name_comparator}",
  uniqueCombinations = TRUE
)
}
\arguments{
\item{result}{A summariseCohortOverlap result.}

\item{facetVarX}{column in data to facet by on horizontal axis}

\item{facetVarY}{column in data to facet by on vertical axis}

\item{colorVars}{column in data to color by}

\item{overlapLabel}{A glue expression to identify each plotted cohort
overlap.}

\item{uniqueCombinations}{If TRUE, only unique combinations of reference and
comparator plots will be plotted.}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("deprecated")`
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- PatientProfiles::mockPatientProfiles()
overlap <- summariseCohortOverlap(cdm$cohort2)
plotCohortOverlap(overlap)
}

}
