% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtResult.R
\name{formatCharacteristics}
\alias{formatCharacteristics}
\title{Format a summarised_characteristics object into a visual table.}
\usage{
formatCharacteristics(
  result,
  type = "gt",
  splitStrata = TRUE,
  format = c(`N (\%)` = "<count> (<percentage>\%)", N = "<count>",
    "<median> [<q25> - <q75>]", "<mean> (<sd>)", range = "<min> to <max>"),
  cdmName = TRUE,
  cohortName = TRUE,
  style = "default",
  minCellCount = 5,
  .options = list()
)
}
\arguments{
\item{result}{A summarised_characteristics object.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{splitStrata}{Whether or not to split the strata, default is True.}

\item{format}{The columns that the user wishes to see for the
formatted table.}

\item{cdmName}{Whether or not to display the cdm name, default is TRUE.}

\item{cohortName}{Weather or not to display the cohort name, default is TRUE.}

\item{style}{The style of the table output.}

\item{minCellCount}{Default is 5, meaning results that are more than
0 but less than 5 will not be reported.}

\item{.options}{See optionsTableCharacteristics() for default values.}
}
\value{
A tibble with a tidy version of the summarised_characteristics
object.
}
\description{
`r lifecycle::badge("deprecated")`
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

cdm$cohort1 |>
  summariseCharacteristics()

CDMConnector::cdmDisconnect(cdm = cdm)
}

}
