% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortIntersect.R
\name{summariseCohortIntersect}
\alias{summariseCohortIntersect}
\title{Summarise cohort intersection information}
\usage{
summariseCohortIntersect(cohort, cohortIntersect = list(), strata = list())
}
\arguments{
\item{cohort}{A cohort in the cdm.}

\item{cohortIntersect}{The settings for cohort intersection settings.}

\item{strata}{Stratification list.}
}
\value{
A summary of the cohort intersection informations.
}
\description{
Summarise cohort intersection information
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

summariseCohortIntersect(
  cohort = cdm$cohort1,
  cohortIntersect = list(
    "Medications in the prior year" = list(
      targetCohortTable = "cohort2", value = "flag", window = c(-365, -1)
    )
  )
)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
