% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCharacteristics.R
\name{summariseCharacteristics}
\alias{summariseCharacteristics}
\title{Summarise characteristics of individuals}
\usage{
summariseCharacteristics(
  cohort,
  cdm = attr(cohort, "cdm_reference"),
  strata = list(),
  ageGroup = NULL,
  tableIntersect = list(),
  cohortIntersect = list(),
  minCellCount = 5
)
}
\arguments{
\item{cohort}{A cohort in the cdm}

\item{cdm}{A cdm reference.}

\item{strata}{Stratification list}

\item{ageGroup}{A list of age groups.}

\item{tableIntersect}{A list of arguments that uses addTableIntersect
function to add covariates and comorbidities.}

\item{cohortIntersect}{A list of arguments that uses addCohortIntersect
function to add covariates and comorbidities.}

\item{minCellCount}{minimum counts due to obscure}
}
\value{
A summary of the characteristics of the individuals
}
\description{
Summarise characteristics of individuals
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

summariseCharacteristics(
  cohort = cdm$cohort1,
  ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150)),
  tableIntersect = list(
    "Visits" = list(
      tableName = "visit_occurrence", value = "count", window = c(-365, 0)
    )
  ),
  cohortIntersect = list(
    "Medications" = list(
      targetCohortTable = "cohort2", value = "flag", window = c(-365, 0)
    )
  )
)
}
}
