% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{simulatePlpData}
\alias{simulatePlpData}
\title{Generate simulated data}
\usage{
simulatePlpData(plpDataSimulationProfile, n = 10000)
}
\arguments{
\item{plpDataSimulationProfile}{An object of type \code{plpDataSimulationProfile} as generated
using the \cr\code{createplpDataSimulationProfile} function.}

\item{n}{The size of the population to be generated.}
}
\value{
An object of type \code{plpData}.
}
\description{
\code{simulateplpData} creates a plpData object with simulated data.
}
\details{
This function generates simulated data that is in many ways similar to the original data on which
the simulation profile is based.
}
\examples{
# first load the simulation profile to use
data("simulationProfile")
# then generate the simulated data
plpData <- simulatePlpData(simulationProfile, n = 100)
nrow(plpData$cohorts)
}
