% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{dGenPareto}
\alias{dGenPareto}
\title{Density of the generalized Pareto Distribution}
\usage{
dGenPareto(x, t, alpha_ini, alpha_tail, truncation = NULL)
}
\arguments{
\item{x}{Numeric. The function evaluates the density at x.}

\item{t}{Numeric. Threshold of the Pareto distribution.}

\item{alpha_ini}{Numeric. Initial Pareto alpha.}

\item{alpha_tail}{Numeric. Tail Pareto alpha.}

\item{truncation}{Numeric. If truncation is not NULL and truncation > t, then the generalized Pareto distribution is truncated at truncation.}
}
\value{
Density function of the Pareto distribution with parameters \code{t}, \code{alpha_ini} and \code{alpha_tail} evaluated at \code{x}
}
\description{
Calculates the density function of the generalized Pareto distribution
}
\examples{
x <- 0:10 * 1000
dGenPareto(x, 1000, 1, 3)
dGenPareto(x, 1000, 1, 3, truncation = 5000)

}
