% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{jointIDA_parallel}
\alias{jointIDA_parallel}
\title{Estimate  Total Causal Effects  of Joint Interventions}
\usage{
jointIDA_parallel(datacsv, cause, effect, pcmethod = "stable", alpha,
  num.cores = 1, mem.efficient = FALSE, technique = c("RRC", "MCD"))
}
\arguments{
\item{datacsv}{The dataset in csv format with rows are samples and columns are variables.}

\item{cause}{The number of integer positions of the intervention variables in the dataset.}

\item{effect}{the integer position of the target variable in the dataset.}

\item{pcmethod}{Character string specifying the method of the PC algorithm, e.g. stable for stable-PC, and parallel for parallel-PC.}

\item{alpha}{significance level (number in (0; 1) for the conditional independence tests.}

\item{num.cores}{The numbers of cores CPU to run the algorithm}

\item{mem.efficient}{If TRUE, uses less amount of memory at any time point while running the algorithm}

\item{technique}{The character string specifying the technique that will be used to estimate the total joint causal effects in the pcalg package.
RRC for Recursive regression for causal effects
MCD for Modifying the Cholesky decomposition}
}
\value{
A matrix that shows the causal effects  of the causes (rows) on the effect. Different columns show different possible causal effect values.
}
\description{
This is the parallelised version of the IDA (stable) algorithm in the pcalg package.
}
\examples{
##########################################
## Using IDA_parallel without mem.efficeient
##########################################
library(bnlearn)
library(pcalg)
library(parallel)
data("gmI")
datacsv <- cov(gmI$x)
jointIDA_parallel(datacsv,1:2,3, pcmethod="parallel",0.01, 2, technique="RRC")

##########################################
## Using IDA_parallel with mem.efficeient
##########################################
library(bnlearn)
library(pcalg)
library(parallel)
data("gmI")
datacsv <- cov(gmI$x)
jointIDA_parallel(datacsv,1:2,3, pcmethod="parallel",0.01, 2, TRUE, technique="RRC")
}

